create or replace package tbicds.PCK_APP_MENU2
AUTHID CURRENT_USER 
is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/****
Get tool bar items
***/
procedure GetToolbarItemsRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out sys_refcursor);
                              

  /*****
  Gets Menu Root Items
  *****/
  procedure GetMenuRootLevelRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_nAppID           in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out sys_refcursor);

  /*****
  Gets Menu Child Items
  *****/
  procedure GetMenuChildItemsRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nAppID           in number,
                                pi_nItemID          in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out sys_refcursor);

  /*****
  Get all menu items for a specific app id
  *****/
  procedure GetAllMenuItemsRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_nAppID           in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out sys_refcursor);

  function fnGetLangPref(pi_nUserID in number) return number;

end PCK_APP_MENU2;
/

